/**
 * FILE: z650IntcInterrupts.h
 *
 *  DESCRIPTION: Contains defines for utilising the Interrupt Controller in the MPC5500. 
 *   There is also the function prototypes for the common interrupt handling 
 *   routines to be used on the MPC5500 (zen core).
 *
 */

#ifndef _Z650INTCINTERRUPTS_H_
#define _Z650INTCINTERRUPTS_H_

/*----------------------------------------------------------------------------*/
/* Types                                                                      */
/*----------------------------------------------------------------------------*/

/** All interrupt handlers should be of this type */
typedef void(*INTCInterruptFn)();

/*----------------------------------------------------------------------------*/
/* Function declarations                                                      */
/*----------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

/**
 * This function is used to Handle the interrupt source by jumping to the ISR
   branch table (IACKR)
 */
void __INTCInterruptHandler__(void);

/**
 * This function will setup the zen to jump to an Interrupt Service Routine
 * handler.  
 *
 * warning This function can only be called after the stack has been
 *          initialised (it saves working registers during the call on r1).
 */																
void __initINTCInterrupts(void);

/**
 * This function can be used to install an interrupt handler for a given
 * interrupt vector. It will also set the Priority Status Register for the
 * source to the one given
 * \param handlerFn The function to call when the interrupt occurs.
 * \param vectoryNum The number of the INTC Interrupt Request Source we wish 
 * to install the handler for.
 * \param psrPriority The priority to set in the Interrupt Controller Priority
 * Select Register.
 */
void InstallINTCInterruptHandler(INTCInterruptFn handlerFn, unsigned short vectorNum,
                                 unsigned char psrPriority);
/**
* Function for Z1 / Z0 specific interrupt initialization
*/ 
void __initZ1Interrupts(void);
 
#ifdef __cplusplus
}
#endif

#endif

